//
//  MCSearchFieldRegistry.h
//  MCApplication
//
//  Created by Ali Lalani on 05/01/05.
//  Copyright 2005 Marketcircle Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>


@interface MCSearchFieldRegistry : NSObject {
	@private
	
	NSMutableArray *_searchFieldConfigs;
	
	NSMutableArray *_currentSettings; // search fields can see if anyone has any settings they should copy
}

+ (MCSearchFieldRegistry *)defaultRegistry;

- (void)registerSearchFieldConfigs:(NSArray *)configs;
- (void)registerSearchFieldConfig:(NSDictionary *)config;
- (NSDictionary *)searchFieldConfigForIdentifier:(NSString *)anIdentifier;
- (NSMutableArray *)searchFieldConfigs;
- (void)setSearchFieldConfigs:(NSMutableArray *)anArray;

- (NSMutableArray *)currentSettings;
- (void)setCurrentSettings:(NSMutableArray *)aCurrentSettings;
- (NSMutableDictionary *)settingForTarget:(id)anObject;
@end
